/*
	icst.show_directivity.js : part of the ICST Ambisonics tools 
	- replaces lcd-based version

	(c) 2021 ICST Zurich University of the Arts
*/
autowatch=0;inlets=3;outlets=2;mgraphics.init();mgraphics.relative_coords=0;mgraphics.autofill=0;var bgcolor=[0.0,0.125,0.25,1.0];var linecolor=[0.75,0.9,1.0,0.8];var textcolor=[1.0,1.0,1.0,0.5];var gridcolor=[1.0,1.0,1.0,0.15];var gWidth;var gHeight;var gAspect;var gFactor=1.0;function init(){calcAspect()}init();function msg_float(f){gFactor=clip(f,0,100.0);mgraphics.redraw()}msg_float.immediate=1;function paint(){var i,j,k;with(mgraphics){scale(0.98,0.98);translate(4,4);set_source_rgba(bgcolor);rectangle(-2,-2,gHeight-1,gHeight+4);fill();rectangle(gHeight,-2,gHeight,gHeight+4);fill();set_source_rgba(1,1,1,1);set_source_rgba(gridcolor);move_to(0,gHeight*0.5);line_to(gHeight,gHeight*0.5);stroke();move_to(gHeight*0.5,0);line_to(gHeight*0.5,gHeight);stroke();set_source_rgba(textcolor);select_font_face("Arial");set_font_size(11);move_to(2,gHeight*0.5-3.5);show_text("-90º");move_to(gHeight-26,gHeight*0.5-3.5);show_text("+90º");move_to(gHeight*0.5+1,15);show_text("0º");move_to(gHeight*0.5-5,gHeight-3.5);show_text("– +180º");set_source_rgba(1,1,1,1);set_source_rgba(gridcolor);move_to(gHeight*1.25,0);line_to(gHeight*1.25,gHeight);stroke();move_to(gHeight*1.5,0);line_to(gHeight*1.5,gHeight);stroke();move_to(gHeight*1.75,0);line_to(gHeight*1.75,gHeight);stroke();set_source_rgba(textcolor);move_to(gHeight,gHeight*0.5-3.5);show_text("–180º");move_to(gHeight*1.25+2,gHeight*0.5-3.5);show_text("–90º");move_to(gHeight*1.5+2,gHeight*0.5-3.5);show_text("0º");move_to(gHeight*1.75+2,gHeight*0.5-3.5);show_text("90º");move_to(gHeight*2-26,gHeight*0.5-3.5);show_text("180º");set_source_rgba(linecolor);move_to(gHeight*0.5,gHeight*0.5);for(var i=0;i<361;i+=1){var v1=to_radians((i-1.0)-180.0);var amplitude=Math.pow(0.5*(1.0+Math.cos(v1)),gFactor);var phase=to_radians((i-1.0)+90.0);var x=Math.cos(phase)*amplitude;var y=Math.sin(phase)*amplitude;x=(x+1)*(gHeight)*0.5;y=(y+1)*(gHeight)*0.5;line_to(x,y)}stroke();set_source_rgba(linecolor);move_to(gHeight+1,gHeight);for(var i=0;i<361;i+=1){var v1=to_radians((i-1.0)-180.0);var amplitude=Math.pow(0.5*(1.0+Math.cos(v1)),gFactor);var localX=(i/361.)*(gHeight-2);var x=localX+1+gHeight;var y=gHeight-(amplitude*gHeight);line_to(x,y)}line_to(2*gHeight-1,gHeight);stroke()}}function calcAspect(){gWidth=this.box.rect[2]-this.box.rect[0];gHeight=this.box.rect[3]-this.box.rect[1];gAspect=gWidth/gHeight}function onresize(gWidth,gHeight){calcAspect()}function to_degrees(rad_value){return rad_value*57.2957795130823208}to_degrees.immediate=1;function to_radians(deg_value){return deg_value*0.0174532925199432}to_radians.immediate=1;function clip(f,a,b){return Math.max(Math.min(f,Math.max(a,b)),Math.min(a,b))}clip.local=1;